using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    const long INF = (long)1e18;

    static long Desno(long[,] a, int i, int n)
    {
        int j = 1;
        while (i + j < n && a[i + j, 1] < a[i, 1]) j++;
        

        if (i + j >= n) return INF;

        long dx = a[i + j, 0] - a[i, 0];
        if (dx < 0) dx = -dx;

        return dx - a[i + j, 1] + a[i, 1];
    }


    static long Levo(long[,] a, int i, int n)
    {
         int j = 1;
         while (i - j >= 0 && a[i - j, 1] < a[i, 1])  j++;
       

         if (i - j < 0) return INF;

         long dx = a[i, 0] - a[i - j, 0];
         if (dx < 0) dx = -dx;

        return dx - a[i - j, 1] + a[i, 1];
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());

        long[] x = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] h = Console.ReadLine().Split().Select(long.Parse).ToArray();

        var tacke = new List<(long x, long h)>();
        for (int i = 0; i < n; i++)  tacke.Add((x[i], h[i]));
           

        tacke = tacke.OrderBy(p => p.x).ToList();

        long[,] a = new long[n, 3];
        for (int i = 0; i < n; i++)
        {
            a[i, 0] = tacke[i].x;
            a[i, 1] = tacke[i].h;
        }

        // nadi najvišu tacku u SORTIRANOM nizu
        int maxIndex = 0;
        for (int i = 1; i < n; i++)
            if (a[i, 1] > a[maxIndex, 1]) maxIndex = i;
                

        for (int i = 0; i < n; i++)
        {
            if (i == maxIndex)  a[i, 2] = -1;
               
            else  a[i, 2] = Math.Min(Levo(a, i, n), Desno(a, i, n));
               
        }

        for (int i = 0; i < n; i++) Console.WriteLine(a[i, 2]); 
            
    }
}